/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Crop169: ImageVector
    get() {
        if (_crop169 != null) {
            return _crop169!!
        }
        _crop169 = materialIcon(name = "Sharp.Crop169") {
            materialPath {
                moveTo(21.0f, 7.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(18.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(19.0f, 15.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(15.0f)
                close()
            }
        }
        return _crop169!!
    }

private var _crop169: ImageVector? = null
