/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.CommentsDisabled: ImageVector
    get() {
        if (_commentsDisabled != null) {
            return _commentsDisabled!!
        }
        _commentsDisabled = materialIcon(name = "Sharp.CommentsDisabled") {
            materialPath {
                moveTo(16.83f, 14.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.17f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(-6.17f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(8.83f)
                lineToRelative(-4.0f, -4.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(17.17f)
                lineTo(16.83f, 14.0f)
                close()
                moveTo(2.1f, 2.1f)
                lineTo(0.69f, 3.51f)
                lineTo(2.0f, 4.83f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(13.17f)
                lineToRelative(5.31f, 5.31f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.1f, 2.1f)
                close()
                moveTo(6.0f, 9.0f)
                horizontalLineToRelative(0.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(6.0f, 14.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(6.0f)
                close()
            }
        }
        return _commentsDisabled!!
    }

private var _commentsDisabled: ImageVector? = null
