/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Colorize: ImageVector
    get() {
        if (_colorize != null) {
            return _colorize!!
        }
        _colorize = materialIcon(name = "Sharp.Colorize") {
            materialPath {
                moveTo(21.42f, 6.34f)
                lineToRelative(-3.75f, -3.75f)
                lineToRelative(-3.82f, 3.82f)
                lineToRelative(-1.94f, -1.91f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(1.42f, 1.42f)
                lineTo(3.0f, 16.25f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(4.75f)
                lineToRelative(8.92f, -8.92f)
                lineToRelative(1.42f, 1.42f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-1.92f, -1.92f)
                lineToRelative(3.84f, -3.83f)
                close()
                moveTo(6.92f, 19.0f)
                lineTo(5.0f, 17.08f)
                lineToRelative(8.06f, -8.06f)
                lineToRelative(1.92f, 1.92f)
                lineTo(6.92f, 19.0f)
                close()
            }
        }
        return _colorize!!
    }

private var _colorize: ImageVector? = null
