/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WatchOff: ImageVector
    get() {
        if (_watchOff != null) {
            return _watchOff!!
        }
        _watchOff = materialIcon(name = "Rounded.WatchOff") {
            materialPath {
                moveTo(12.0f, 7.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                curveToRelative(0.0f, 0.64f, -0.13f, 1.25f, -0.35f, 1.82f)
                lineToRelative(1.5f, 1.5f)
                curveTo(18.69f, 14.33f, 19.0f, 13.2f, 19.0f, 12.0f)
                curveToRelative(0.0f, -2.22f, -1.03f, -4.19f, -2.64f, -5.47f)
                lineToRelative(-0.93f, -3.1f)
                curveTo(15.17f, 2.58f, 14.4f, 2.0f, 13.51f, 2.0f)
                horizontalLineToRelative(-3.02f)
                curveTo(9.6f, 2.0f, 8.83f, 2.58f, 8.57f, 3.42f)
                lineTo(8.04f, 5.21f)
                lineToRelative(2.14f, 2.14f)
                curveTo(10.75f, 7.13f, 11.36f, 7.0f, 12.0f, 7.0f)
                close()
            }
            materialPath {
                moveTo(2.1f, 3.51f)
                lineTo(2.1f, 3.51f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.75f, 3.75f)
                curveTo(5.31f, 9.67f, 5.0f, 10.8f, 5.0f, 12.0f)
                curveToRelative(0.0f, 2.22f, 1.03f, 4.19f, 2.64f, 5.47f)
                lineToRelative(0.93f, 3.1f)
                curveTo(8.83f, 21.42f, 9.6f, 22.0f, 10.49f, 22.0f)
                horizontalLineToRelative(3.02f)
                curveToRelative(0.88f, 0.0f, 1.66f, -0.58f, 1.92f, -1.43f)
                lineToRelative(0.53f, -1.78f)
                lineToRelative(3.11f, 3.11f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(3.51f, 3.51f)
                curveTo(3.12f, 3.12f, 2.49f, 3.12f, 2.1f, 3.51f)
                close()
                moveTo(12.0f, 17.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                curveToRelative(0.0f, -0.64f, 0.13f, -1.25f, 0.35f, -1.82f)
                lineToRelative(6.47f, 6.47f)
                curveTo(13.25f, 16.87f, 12.64f, 17.0f, 12.0f, 17.0f)
                close()
            }
        }
        return _watchOff!!
    }

private var _watchOff: ImageVector? = null
