/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SupervisorAccount: ImageVector
    get() {
        if (_supervisorAccount != null) {
            return _supervisorAccount!!
        }
        _supervisorAccount = materialIcon(name = "Rounded.SupervisorAccount") {
            materialPath {
                moveTo(16.5f, 12.0f)
                curveToRelative(1.38f, 0.0f, 2.49f, -1.12f, 2.49f, -2.5f)
                reflectiveCurveTo(17.88f, 7.0f, 16.5f, 7.0f)
                reflectiveCurveTo(14.0f, 8.12f, 14.0f, 9.5f)
                reflectiveCurveToRelative(1.12f, 2.5f, 2.5f, 2.5f)
                close()
                moveTo(9.0f, 11.0f)
                curveToRelative(1.66f, 0.0f, 2.99f, -1.34f, 2.99f, -3.0f)
                reflectiveCurveTo(10.66f, 5.0f, 9.0f, 5.0f)
                reflectiveCurveTo(6.0f, 6.34f, 6.0f, 8.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                close()
                moveTo(16.5f, 14.0f)
                curveToRelative(-1.83f, 0.0f, -5.5f, 0.92f, -5.5f, 2.75f)
                lineTo(11.0f, 18.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(9.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.25f)
                curveToRelative(0.0f, -1.83f, -3.67f, -2.75f, -5.5f, -2.75f)
                close()
                moveTo(9.0f, 13.0f)
                curveToRelative(-2.33f, 0.0f, -7.0f, 1.17f, -7.0f, 3.5f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-2.25f)
                curveToRelative(0.0f, -0.85f, 0.33f, -2.34f, 2.37f, -3.47f)
                curveTo(10.5f, 13.1f, 9.66f, 13.0f, 9.0f, 13.0f)
                close()
            }
        }
        return _supervisorAccount!!
    }

private var _supervisorAccount: ImageVector? = null
