/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SupervisedUserCircle: ImageVector
    get() {
        if (_supervisedUserCircle != null) {
            return _supervisedUserCircle!!
        }
        _supervisedUserCircle = materialIcon(name = "Rounded.SupervisedUserCircle") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(15.61f, 8.34f)
                curveToRelative(1.07f, 0.0f, 1.93f, 0.86f, 1.93f, 1.93f)
                reflectiveCurveToRelative(-0.86f, 1.93f, -1.93f, 1.93f)
                reflectiveCurveToRelative(-1.93f, -0.86f, -1.93f, -1.93f)
                curveToRelative(-0.01f, -1.07f, 0.86f, -1.93f, 1.93f, -1.93f)
                close()
                moveTo(9.61f, 6.76f)
                curveToRelative(1.3f, 0.0f, 2.36f, 1.06f, 2.36f, 2.36f)
                reflectiveCurveToRelative(-1.06f, 2.36f, -2.36f, 2.36f)
                reflectiveCurveToRelative(-2.36f, -1.06f, -2.36f, -2.36f)
                curveToRelative(0.0f, -1.31f, 1.05f, -2.36f, 2.36f, -2.36f)
                close()
                moveTo(9.61f, 15.89f)
                verticalLineToRelative(3.75f)
                curveToRelative(-2.4f, -0.75f, -4.3f, -2.6f, -5.14f, -4.96f)
                curveToRelative(1.05f, -1.12f, 3.67f, -1.69f, 5.14f, -1.69f)
                curveToRelative(0.53f, 0.0f, 1.2f, 0.08f, 1.9f, 0.22f)
                curveToRelative(-1.64f, 0.87f, -1.9f, 2.02f, -1.9f, 2.68f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-0.27f, 0.0f, -0.53f, -0.01f, -0.79f, -0.04f)
                verticalLineToRelative(-4.07f)
                curveToRelative(0.0f, -1.42f, 2.94f, -2.13f, 4.4f, -2.13f)
                curveToRelative(1.07f, 0.0f, 2.92f, 0.39f, 3.84f, 1.15f)
                curveTo(18.28f, 17.88f, 15.39f, 20.0f, 12.0f, 20.0f)
                close()
            }
        }
        return _supervisedUserCircle!!
    }

private var _supervisedUserCircle: ImageVector? = null
