/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SocialDistance: ImageVector
    get() {
        if (_socialDistance != null) {
            return _socialDistance!!
        }
        _socialDistance = materialIcon(name = "Rounded.SocialDistance") {
            materialPath {
                moveTo(4.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(4.0f, 6.1f, 4.0f, 5.0f)
                close()
                moveTo(8.78f, 8.58f)
                curveTo(7.93f, 8.21f, 6.99f, 8.0f, 6.0f, 8.0f)
                reflectiveCurveTo(4.07f, 8.21f, 3.22f, 8.58f)
                curveTo(2.48f, 8.9f, 2.0f, 9.62f, 2.0f, 10.43f)
                lineTo(2.0f, 11.0f)
                horizontalLineToRelative(8.0f)
                lineToRelative(0.0f, -0.57f)
                curveTo(10.0f, 9.62f, 9.52f, 8.9f, 8.78f, 8.58f)
                close()
                moveTo(18.0f, 7.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                curveTo(16.0f, 6.1f, 16.9f, 7.0f, 18.0f, 7.0f)
                close()
                moveTo(20.78f, 8.58f)
                curveTo(19.93f, 8.21f, 18.99f, 8.0f, 18.0f, 8.0f)
                curveToRelative(-0.99f, 0.0f, -1.93f, 0.21f, -2.78f, 0.58f)
                curveTo(14.48f, 8.9f, 14.0f, 9.62f, 14.0f, 10.43f)
                lineTo(14.0f, 11.0f)
                horizontalLineToRelative(8.0f)
                lineToRelative(0.0f, -0.57f)
                curveTo(22.0f, 9.62f, 21.52f, 8.9f, 20.78f, 8.58f)
                close()
                moveTo(21.65f, 16.65f)
                lineToRelative(-2.79f, -2.79f)
                curveTo(18.54f, 13.54f, 18.0f, 13.76f, 18.0f, 14.21f)
                verticalLineTo(16.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-1.79f)
                curveToRelative(0.0f, -0.45f, -0.54f, -0.67f, -0.85f, -0.35f)
                lineToRelative(-2.79f, 2.79f)
                curveToRelative(-0.2f, 0.2f, -0.2f, 0.51f, 0.0f, 0.71f)
                lineToRelative(2.79f, 2.79f)
                curveTo(5.46f, 20.46f, 6.0f, 20.24f, 6.0f, 19.79f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(1.79f)
                curveToRelative(0.0f, 0.45f, 0.54f, 0.67f, 0.85f, 0.35f)
                lineToRelative(2.79f, -2.79f)
                curveTo(21.84f, 17.16f, 21.84f, 16.84f, 21.65f, 16.65f)
                close()
            }
        }
        return _socialDistance!!
    }

private var _socialDistance: ImageVector? = null
