/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SettingsBluetooth: ImageVector
    get() {
        if (_settingsBluetooth != null) {
            return _settingsBluetooth!!
        }
        _settingsBluetooth = materialIcon(name = "Rounded.SettingsBluetooth") {
            materialPath {
                moveTo(12.0f, 23.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(8.0f, 23.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(16.0f, 23.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(13.41f, 10.0f)
                lineTo(17.0f, 6.42f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.42f)
                lineToRelative(-4.79f, -4.79f)
                curveTo(12.07f, 0.07f, 11.89f, 0.0f, 11.71f, 0.0f)
                curveTo(11.32f, 0.0f, 11.0f, 0.32f, 11.0f, 0.71f)
                verticalLineToRelative(6.88f)
                lineTo(7.11f, 3.71f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(10.59f, 10.0f)
                lineToRelative(-4.89f, 4.89f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineTo(11.0f, 12.41f)
                verticalLineToRelative(6.88f)
                curveToRelative(0.0f, 0.39f, 0.32f, 0.71f, 0.71f, 0.71f)
                curveToRelative(0.19f, 0.0f, 0.37f, -0.07f, 0.5f, -0.21f)
                lineTo(17.0f, 15.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.42f)
                lineTo(13.41f, 10.0f)
                close()
                moveTo(13.0f, 3.83f)
                lineToRelative(1.88f, 1.88f)
                lineTo(13.0f, 7.59f)
                verticalLineTo(3.83f)
                close()
                moveTo(13.0f, 16.17f)
                verticalLineToRelative(-3.76f)
                lineToRelative(1.88f, 1.88f)
                lineTo(13.0f, 16.17f)
                close()
            }
        }
        return _settingsBluetooth!!
    }

private var _settingsBluetooth: ImageVector? = null
