/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SettingsApplications: ImageVector
    get() {
        if (_settingsApplications != null) {
            return _settingsApplications!!
        }
        _settingsApplications = materialIcon(name = "Rounded.SettingsApplications") {
            materialPath {
                moveTo(12.0f, 12.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.89f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.11f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(15.75f, 12.0f)
                curveToRelative(0.0f, 0.22f, -0.03f, 0.42f, -0.06f, 0.63f)
                lineToRelative(0.84f, 0.73f)
                curveToRelative(0.18f, 0.16f, 0.22f, 0.42f, 0.1f, 0.63f)
                lineToRelative(-0.59f, 1.02f)
                curveToRelative(-0.12f, 0.21f, -0.37f, 0.3f, -0.59f, 0.22f)
                lineToRelative(-1.06f, -0.36f)
                curveToRelative(-0.32f, 0.27f, -0.68f, 0.48f, -1.08f, 0.63f)
                lineToRelative(-0.22f, 1.09f)
                curveToRelative(-0.05f, 0.23f, -0.25f, 0.4f, -0.49f, 0.4f)
                horizontalLineToRelative(-1.18f)
                curveToRelative(-0.24f, 0.0f, -0.44f, -0.17f, -0.49f, -0.4f)
                lineToRelative(-0.22f, -1.09f)
                curveToRelative(-0.4f, -0.15f, -0.76f, -0.36f, -1.08f, -0.63f)
                lineToRelative(-1.06f, 0.36f)
                curveToRelative(-0.23f, 0.08f, -0.47f, -0.02f, -0.59f, -0.22f)
                lineToRelative(-0.59f, -1.02f)
                curveToRelative(-0.12f, -0.21f, -0.08f, -0.47f, 0.1f, -0.63f)
                lineToRelative(0.84f, -0.73f)
                curveTo(8.28f, 12.42f, 8.25f, 12.22f, 8.25f, 12.0f)
                reflectiveCurveToRelative(0.03f, -0.42f, 0.06f, -0.63f)
                lineToRelative(-0.84f, -0.73f)
                curveToRelative(-0.18f, -0.16f, -0.22f, -0.42f, -0.1f, -0.63f)
                lineToRelative(0.59f, -1.02f)
                curveToRelative(0.12f, -0.21f, 0.37f, -0.3f, 0.59f, -0.22f)
                lineToRelative(1.06f, 0.36f)
                curveToRelative(0.32f, -0.27f, 0.68f, -0.48f, 1.08f, -0.63f)
                lineToRelative(0.22f, -1.09f)
                curveTo(10.97f, 7.17f, 11.17f, 7.0f, 11.41f, 7.0f)
                horizontalLineToRelative(1.18f)
                curveToRelative(0.24f, 0.0f, 0.44f, 0.17f, 0.49f, 0.4f)
                lineToRelative(0.22f, 1.09f)
                curveToRelative(0.4f, 0.15f, 0.76f, 0.36f, 1.08f, 0.63f)
                lineToRelative(1.06f, -0.36f)
                curveToRelative(0.23f, -0.08f, 0.47f, 0.02f, 0.59f, 0.22f)
                lineToRelative(0.59f, 1.02f)
                curveToRelative(0.12f, 0.21f, 0.08f, 0.47f, -0.1f, 0.63f)
                lineToRelative(-0.84f, 0.73f)
                curveTo(15.72f, 11.58f, 15.75f, 11.78f, 15.75f, 12.0f)
                close()
            }
        }
        return _settingsApplications!!
    }

private var _settingsApplications: ImageVector? = null
