/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ReplayCircleFilled: ImageVector
    get() {
        if (_replayCircleFilled != null) {
            return _replayCircleFilled!!
        }
        _replayCircleFilled = materialIcon(name = "Rounded.ReplayCircleFilled") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(18.0f, 12.74f)
                curveToRelative(-0.12f, 3.09f, -2.67f, 5.64f, -5.76f, 5.76f)
                curveToRelative(-3.01f, 0.12f, -5.56f, -1.99f, -6.12f, -4.82f)
                curveTo(5.99f, 13.07f, 6.48f, 12.5f, 7.1f, 12.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.47f, 0.0f, 0.88f, 0.33f, 0.98f, 0.8f)
                curveToRelative(0.42f, 2.07f, 2.44f, 3.57f, 4.72f, 3.12f)
                curveToRelative(1.56f, -0.3f, 2.82f, -1.56f, 3.12f, -3.12f)
                curveToRelative(0.5f, -2.56f, -1.45f, -4.8f, -3.92f, -4.8f)
                verticalLineToRelative(1.79f)
                curveToRelative(0.0f, 0.45f, -0.54f, 0.67f, -0.85f, 0.35f)
                lineTo(8.35f, 7.85f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(2.79f, -2.79f)
                curveTo(11.46f, 4.04f, 12.0f, 4.26f, 12.0f, 4.71f)
                verticalLineTo(6.5f)
                curveTo(15.39f, 6.5f, 18.13f, 9.32f, 18.0f, 12.74f)
                close()
            }
        }
        return _replayCircleFilled!!
    }

private var _replayCircleFilled: ImageVector? = null
