/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RealEstateAgent: ImageVector
    get() {
        if (_realEstateAgent != null) {
            return _realEstateAgent!!
        }
        _realEstateAgent = materialIcon(name = "Rounded.RealEstateAgent") {
            materialPath {
                moveTo(3.0f, 22.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-7.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(7.0f)
                curveTo(1.0f, 21.1f, 1.9f, 22.0f, 3.0f, 22.0f)
                close()
                moveTo(11.37f, 16.43f)
                lineToRelative(1.47f, 0.51f)
                curveToRelative(0.11f, 0.04f, 0.22f, 0.06f, 0.33f, 0.06f)
                horizontalLineToRelative(6.83f)
                curveToRelative(1.11f, 0.0f, 2.0f, 0.89f, 2.01f, 2.0f)
                lineToRelative(0.0f, 0.0f)
                lineToRelative(-7.39f, 2.77f)
                curveToRelative(-0.4f, 0.15f, -0.84f, 0.17f, -1.25f, 0.05f)
                lineTo(7.0f, 20.02f)
                verticalLineTo(11.0f)
                horizontalLineTo(8.6f)
                curveToRelative(0.24f, 0.0f, 0.48f, 0.04f, 0.7f, 0.13f)
                lineToRelative(6.93f, 2.59f)
                curveToRelative(0.46f, 0.17f, 0.77f, 0.61f, 0.77f, 1.11f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.65f, -0.53f, 1.18f, -1.18f, 1.18f)
                horizontalLineToRelative(-2.63f)
                curveToRelative(-0.12f, 0.0f, -0.24f, -0.02f, -0.36f, -0.07f)
                lineToRelative(-1.12f, -0.43f)
                curveToRelative(-0.26f, -0.1f, -0.55f, 0.04f, -0.64f, 0.3f)
                curveTo(10.98f, 16.06f, 11.11f, 16.34f, 11.37f, 16.43f)
                close()
                moveTo(20.16f, 5.9f)
                lineToRelative(-5.0f, -3.57f)
                curveToRelative(-0.7f, -0.5f, -1.63f, -0.5f, -2.32f, 0.0f)
                lineToRelative(-5.0f, 3.57f)
                curveTo(7.31f, 6.28f, 7.0f, 6.88f, 7.0f, 7.53f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.61f)
                curveToRelative(0.25f, 0.0f, 0.51f, 0.05f, 0.74f, 0.14f)
                lineToRelative(7.79f, 3.11f)
                curveTo(18.26f, 12.71f, 19.0f, 13.79f, 19.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.53f)
                curveTo(21.0f, 6.88f, 20.69f, 6.28f, 20.16f, 5.9f)
                close()
                moveTo(13.0f, 10.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveTo(12.5f, 9.22f, 12.72f, 9.0f, 13.0f, 9.0f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(13.5f, 9.78f, 13.28f, 10.0f, 13.0f, 10.0f)
                close()
                moveTo(13.0f, 8.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveTo(12.5f, 7.22f, 12.72f, 7.0f, 13.0f, 7.0f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(13.5f, 7.78f, 13.28f, 8.0f, 13.0f, 8.0f)
                close()
                moveTo(15.0f, 10.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveTo(14.5f, 9.22f, 14.72f, 9.0f, 15.0f, 9.0f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(15.5f, 9.78f, 15.28f, 10.0f, 15.0f, 10.0f)
                close()
                moveTo(15.0f, 8.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveTo(14.5f, 7.22f, 14.72f, 7.0f, 15.0f, 7.0f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(15.5f, 7.78f, 15.28f, 8.0f, 15.0f, 8.0f)
                close()
            }
        }
        return _realEstateAgent!!
    }

private var _realEstateAgent: ImageVector? = null
