/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Plagiarism: ImageVector
    get() {
        if (_plagiarism != null) {
            return _plagiarism!!
        }
        _plagiarism = materialIcon(name = "Rounded.Plagiarism") {
            materialPath {
                moveTo(19.41f, 7.41f)
                lineToRelative(-4.83f, -4.83f)
                curveTo(14.21f, 2.21f, 13.7f, 2.0f, 13.17f, 2.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 2.0f, 4.0f, 2.9f, 4.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(8.83f)
                curveTo(20.0f, 8.3f, 19.79f, 7.79f, 19.41f, 7.41f)
                close()
                moveTo(15.74f, 18.74f)
                lineTo(15.74f, 18.74f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(-1.18f, -1.18f)
                curveToRelative(-1.33f, 0.71f, -3.01f, 0.53f, -4.13f, -0.59f)
                curveToRelative(-1.52f, -1.52f, -1.35f, -4.08f, 0.5f, -5.37f)
                curveToRelative(1.16f, -0.81f, 2.78f, -0.81f, 3.95f, 0.0f)
                curveToRelative(1.55f, 1.08f, 1.9f, 3.04f, 1.09f, 4.55f)
                lineToRelative(1.18f, 1.18f)
                curveTo(16.13f, 17.72f, 16.13f, 18.35f, 15.74f, 18.74f)
                close()
                moveTo(14.0f, 9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(3.5f)
                lineTo(18.5f, 9.0f)
                horizontalLineTo(14.0f)
                close()
            }
            materialPath {
                moveTo(11.5f, 14.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
        }
        return _plagiarism!!
    }

private var _plagiarism: ImageVector? = null
