/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Pentagon: ImageVector
    get() {
        if (_pentagon != null) {
            return _pentagon!!
        }
        _pentagon = materialIcon(name = "Rounded.Pentagon") {
            materialPath {
                moveTo(2.47f, 10.42f)
                lineToRelative(3.07f, 9.22f)
                curveTo(5.82f, 20.45f, 6.58f, 21.0f, 7.44f, 21.0f)
                horizontalLineToRelative(9.12f)
                curveToRelative(0.86f, 0.0f, 1.63f, -0.55f, 1.9f, -1.37f)
                lineToRelative(3.07f, -9.22f)
                curveToRelative(0.28f, -0.84f, -0.03f, -1.76f, -0.75f, -2.27f)
                lineTo(13.15f, 2.8f)
                curveToRelative(-0.69f, -0.48f, -1.61f, -0.48f, -2.29f, 0.0f)
                lineTo(3.22f, 8.14f)
                curveTo(2.5f, 8.65f, 2.19f, 9.58f, 2.47f, 10.42f)
                close()
            }
        }
        return _pentagon!!
    }

private var _pentagon: ImageVector? = null
