/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Mp: ImageVector
    get() {
        if (_mp != null) {
            return _mp!!
        }
        _mp = materialIcon(name = "Rounded.Mp") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(7.0f, 9.0f)
                horizontalLineToRelative(4.5f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.25f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineToRelative(0.0f)
                curveTo(11.34f, 15.0f, 11.0f, 14.66f, 11.0f, 14.25f)
                verticalLineTo(10.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(2.25f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineTo(10.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(3.75f)
                curveTo(7.5f, 14.66f, 7.16f, 15.0f, 6.75f, 15.0f)
                horizontalLineToRelative(0.0f)
                curveTo(6.34f, 15.0f, 6.0f, 14.66f, 6.0f, 14.25f)
                verticalLineTo(10.0f)
                curveTo(6.0f, 9.45f, 6.45f, 9.0f, 7.0f, 9.0f)
                close()
                moveTo(14.25f, 15.0f)
                lineTo(14.25f, 15.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.33f, -0.75f, -0.75f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineTo(17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(2.5f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(0.75f)
                curveTo(15.0f, 14.66f, 14.66f, 15.0f, 14.25f, 15.0f)
                close()
                moveTo(15.0f, 12.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineTo(15.0f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _mp!!
    }

private var _mp: ImageVector? = null
