/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HeartBroken: ImageVector
    get() {
        if (_heartBroken != null) {
            return _heartBroken!!
        }
        _heartBroken = materialIcon(name = "Rounded.HeartBroken") {
            materialPath {
                moveTo(19.57f, 3.95f)
                curveToRelative(-1.92f, -1.29f, -4.08f, -1.17f, -5.8f, -0.26f)
                lineTo(12.0f, 9.0f)
                horizontalLineToRelative(1.66f)
                curveToRelative(0.67f, 0.0f, 1.15f, 0.65f, 0.96f, 1.29f)
                lineToRelative(-1.82f, 6.07f)
                curveToRelative(-0.09f, 0.29f, -0.52f, 0.2f, -0.49f, -0.1f)
                lineTo(13.0f, 10.0f)
                horizontalLineToRelative(-1.67f)
                curveToRelative(-0.66f, 0.0f, -1.14f, -0.64f, -0.96f, -1.27f)
                lineToRelative(1.18f, -4.11f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                curveTo(9.7f, 2.89f, 6.71f, 2.32f, 4.27f, 4.04f)
                curveTo(2.82f, 5.07f, 2.0f, 6.7f, 2.0f, 8.49f)
                curveToRelative(-0.01f, 3.81f, 3.53f, 6.71f, 8.66f, 11.3f)
                curveToRelative(0.76f, 0.68f, 1.92f, 0.69f, 2.69f, 0.01f)
                curveToRelative(4.98f, -4.42f, 8.87f, -7.58f, 8.64f, -11.62f)
                curveTo(21.9f, 6.45f, 21.0f, 4.92f, 19.57f, 3.95f)
                close()
            }
        }
        return _heartBroken!!
    }

private var _heartBroken: ImageVector? = null
