/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HdrAuto: ImageVector
    get() {
        if (_hdrAuto != null) {
            return _hdrAuto!!
        }
        _hdrAuto = materialIcon(name = "Rounded.HdrAuto") {
            materialPath {
                moveTo(12.04f, 8.04f)
                lineToRelative(-0.09f, 0.0f)
                lineToRelative(-1.6f, 4.55f)
                lineToRelative(3.29f, 0.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(15.0f, 16.41f)
                lineToRelative(-0.78f, -2.22f)
                horizontalLineTo(9.78f)
                lineToRelative(-0.79f, 2.22f)
                curveTo(8.87f, 16.76f, 8.53f, 17.0f, 8.16f, 17.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.62f, 0.0f, -1.05f, -0.62f, -0.83f, -1.2f)
                lineToRelative(3.34f, -8.88f)
                curveTo(10.88f, 6.37f, 11.4f, 6.0f, 12.0f, 6.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.59f, 0.0f, 1.12f, 0.37f, 1.33f, 0.92f)
                lineToRelative(3.34f, 8.88f)
                curveToRelative(0.22f, 0.58f, -0.21f, 1.2f, -0.83f, 1.2f)
                horizontalLineToRelative(0.0f)
                curveTo(15.46f, 17.0f, 15.12f, 16.76f, 15.0f, 16.41f)
                close()
            }
        }
        return _hdrAuto!!
    }

private var _hdrAuto: ImageVector? = null
