/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Girl: ImageVector
    get() {
        if (_girl != null) {
            return _girl!!
        }
        _girl = materialIcon(name = "Rounded.Girl") {
            materialPath {
                moveTo(12.0f, 7.5f)
                curveToRelative(0.97f, 0.0f, 1.75f, -0.78f, 1.75f, -1.75f)
                reflectiveCurveTo(12.97f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveToRelative(-1.75f, 0.78f, -1.75f, 1.75f)
                reflectiveCurveTo(11.03f, 7.5f, 12.0f, 7.5f)
                close()
                moveTo(14.0f, 16.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(9.44f)
                curveToRelative(-0.7f, 0.0f, -1.18f, -0.7f, -0.94f, -1.35f)
                lineToRelative(1.88f, -5.03f)
                curveTo(10.63f, 8.95f, 11.28f, 8.5f, 12.0f, 8.5f)
                reflectiveCurveToRelative(1.37f, 0.45f, 1.62f, 1.12f)
                lineToRelative(1.88f, 5.03f)
                curveTo(15.74f, 15.3f, 15.26f, 16.0f, 14.56f, 16.0f)
                horizontalLineTo(14.0f)
                close()
            }
        }
        return _girl!!
    }

private var _girl: ImageVector? = null
