/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Downloading: ImageVector
    get() {
        if (_downloading != null) {
            return _downloading!!
        }
        _downloading = materialIcon(name = "Rounded.Downloading") {
            materialPath {
                moveTo(17.33f, 3.55f)
                curveToRelative(-0.94f, -0.6f, -1.99f, -1.04f, -3.12f, -1.3f)
                curveTo(13.59f, 2.11f, 13.0f, 2.59f, 13.0f, 3.23f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.45f, 0.3f, 0.87f, 0.74f, 0.97f)
                curveToRelative(0.91f, 0.2f, 1.77f, 0.56f, 2.53f, 1.05f)
                curveToRelative(0.39f, 0.25f, 0.89f, 0.17f, 1.22f, -0.16f)
                lineToRelative(0.0f, 0.0f)
                curveTo(17.94f, 4.64f, 17.87f, 3.89f, 17.33f, 3.55f)
                close()
                moveTo(20.77f, 11.0f)
                lineTo(20.77f, 11.0f)
                curveToRelative(0.64f, 0.0f, 1.13f, -0.59f, 0.98f, -1.21f)
                curveToRelative(-0.26f, -1.12f, -0.7f, -2.17f, -1.3f, -3.12f)
                curveToRelative(-0.34f, -0.54f, -1.1f, -0.61f, -1.55f, -0.16f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.32f, 0.32f, -0.4f, 0.83f, -0.16f, 1.22f)
                curveToRelative(0.49f, 0.77f, 0.85f, 1.62f, 1.05f, 2.53f)
                curveTo(19.9f, 10.7f, 20.31f, 11.0f, 20.77f, 11.0f)
                close()
                moveTo(18.9f, 17.49f)
                lineTo(18.9f, 17.49f)
                curveToRelative(0.45f, 0.45f, 1.21f, 0.38f, 1.55f, -0.15f)
                curveToRelative(0.6f, -0.94f, 1.04f, -1.99f, 1.3f, -3.11f)
                curveToRelative(0.14f, -0.62f, -0.35f, -1.21f, -0.98f, -1.21f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.45f, 0.0f, -0.87f, 0.3f, -0.97f, 0.74f)
                curveToRelative(-0.2f, 0.91f, -0.57f, 1.76f, -1.05f, 2.53f)
                curveTo(18.5f, 16.66f, 18.58f, 17.17f, 18.9f, 17.49f)
                close()
                moveTo(13.0f, 20.77f)
                lineTo(13.0f, 20.77f)
                curveToRelative(0.0f, 0.64f, 0.59f, 1.13f, 1.21f, 0.98f)
                curveToRelative(1.12f, -0.26f, 2.17f, -0.7f, 3.11f, -1.3f)
                curveToRelative(0.54f, -0.34f, 0.61f, -1.1f, 0.16f, -1.55f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.32f, -0.32f, -0.83f, -0.4f, -1.21f, -0.15f)
                curveToRelative(-0.76f, 0.49f, -1.61f, 0.85f, -2.53f, 1.05f)
                curveTo(13.3f, 19.9f, 13.0f, 20.31f, 13.0f, 20.77f)
                close()
                moveTo(13.0f, 12.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(9.41f)
                curveToRelative(-0.89f, 0.0f, -1.34f, 1.08f, -0.71f, 1.71f)
                lineToRelative(2.59f, 2.59f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(2.59f, -2.59f)
                curveToRelative(0.63f, -0.63f, 0.18f, -1.71f, -0.71f, -1.71f)
                horizontalLineTo(13.0f)
                close()
                moveTo(11.0f, 20.77f)
                lineTo(11.0f, 20.77f)
                curveToRelative(0.0f, 0.64f, -0.59f, 1.13f, -1.21f, 0.99f)
                curveTo(5.33f, 20.75f, 2.0f, 16.77f, 2.0f, 12.0f)
                reflectiveCurveToRelative(3.33f, -8.75f, 7.79f, -9.75f)
                curveTo(10.41f, 2.11f, 11.0f, 2.59f, 11.0f, 3.23f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.46f, -0.31f, 0.87f, -0.76f, 0.97f)
                curveTo(6.67f, 5.0f, 4.0f, 8.19f, 4.0f, 12.0f)
                reflectiveCurveToRelative(2.67f, 7.0f, 6.24f, 7.8f)
                curveTo(10.69f, 19.9f, 11.0f, 20.31f, 11.0f, 20.77f)
                close()
            }
        }
        return _downloading!!
    }

private var _downloading: ImageVector? = null
