/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BroadcastOnHome: ImageVector
    get() {
        if (_broadcastOnHome != null) {
            return _broadcastOnHome!!
        }
        _broadcastOnHome = materialIcon(name = "Rounded.BroadcastOnHome") {
            materialPath {
                moveTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.0f)
                curveTo(4.45f, 4.0f, 4.0f, 4.45f, 4.0f, 5.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(15.0f)
                verticalLineToRelative(2.59f)
                curveToRelative(0.73f, 0.29f, 1.4f, 0.69f, 2.0f, 1.17f)
                verticalLineTo(6.0f)
                close()
            }
            materialPath {
                moveTo(8.0f, 9.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-0.5f, 0.0f, -1.0f, 0.5f, -1.0f, 1.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(0.5f, 0.0f, 1.0f, -0.5f, 1.0f, -1.0f)
                verticalLineToRelative(-9.0f)
                curveTo(9.0f, 9.5f, 8.5f, 9.0f, 8.0f, 9.0f)
                close()
                moveTo(7.0f, 18.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-7.0f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(17.75f, 16.97f)
                curveToRelative(0.3f, -0.23f, 0.5f, -0.57f, 0.5f, -0.97f)
                curveToRelative(0.0f, -0.69f, -0.56f, -1.25f, -1.25f, -1.25f)
                reflectiveCurveToRelative(-1.25f, 0.56f, -1.25f, 1.25f)
                curveToRelative(0.0f, 0.4f, 0.2f, 0.75f, 0.5f, 0.97f)
                verticalLineToRelative(4.28f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(16.97f)
                close()
            }
            materialPath {
                moveTo(17.54f, 13.56f)
                curveToRelative(0.98f, 0.21f, 1.76f, 1.03f, 1.93f, 2.02f)
                curveToRelative(0.11f, 0.64f, -0.03f, 1.25f, -0.34f, 1.74f)
                curveToRelative(-0.18f, 0.29f, -0.13f, 0.67f, 0.12f, 0.91f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.34f, 0.33f, 0.9f, 0.29f, 1.16f, -0.12f)
                curveToRelative(0.51f, -0.82f, 0.73f, -1.83f, 0.53f, -2.9f)
                curveToRelative(-0.3f, -1.56f, -1.56f, -2.83f, -3.12f, -3.13f)
                curveTo(15.24f, 11.58f, 13.0f, 13.53f, 13.0f, 16.0f)
                curveToRelative(0.0f, 0.78f, 0.22f, 1.5f, 0.6f, 2.11f)
                curveToRelative(0.25f, 0.41f, 0.83f, 0.46f, 1.16f, 0.12f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.24f, -0.24f, 0.29f, -0.63f, 0.11f, -0.92f)
                curveToRelative(-0.24f, -0.38f, -0.37f, -0.83f, -0.37f, -1.31f)
                curveTo(14.5f, 14.45f, 15.93f, 13.22f, 17.54f, 13.56f)
                close()
            }
            materialPath {
                moveTo(16.25f, 9.54f)
                curveToRelative(-2.94f, 0.33f, -5.32f, 2.68f, -5.69f, 5.61f)
                curveToRelative(-0.23f, 1.82f, 0.29f, 3.51f, 1.3f, 4.82f)
                curveToRelative(0.27f, 0.35f, 0.8f, 0.37f, 1.12f, 0.06f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.27f, -0.27f, 0.28f, -0.7f, 0.05f, -1.0f)
                curveToRelative(-0.8f, -1.05f, -1.2f, -2.43f, -0.95f, -3.89f)
                curveToRelative(0.34f, -2.03f, 1.95f, -3.67f, 3.98f, -4.05f)
                curveTo(19.22f, 10.5f, 22.0f, 12.93f, 22.0f, 16.0f)
                curveToRelative(0.0f, 1.13f, -0.38f, 2.18f, -1.02f, 3.02f)
                curveToRelative(-0.23f, 0.3f, -0.21f, 0.73f, 0.06f, 1.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.31f, 0.31f, 0.84f, 0.3f, 1.11f, -0.06f)
                curveTo(23.0f, 18.87f, 23.5f, 17.49f, 23.5f, 16.0f)
                curveTo(23.5f, 12.16f, 20.17f, 9.1f, 16.25f, 9.54f)
                close()
            }
        }
        return _broadcastOnHome!!
    }

private var _broadcastOnHome: ImageVector? = null
