/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AutofpsSelect: ImageVector
    get() {
        if (_autofpsSelect != null) {
            return _autofpsSelect!!
        }
        _autofpsSelect = materialIcon(name = "Rounded.AutofpsSelect") {
            materialPath {
                moveTo(12.03f, 6.3f)
                lineToRelative(-0.06f, 0.0f)
                lineToRelative(-1.02f, 2.89f)
                lineToRelative(2.1f, 0.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 22.0f)
                lineTo(4.0f, 22.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveTo(3.0f, 21.55f, 3.45f, 22.0f, 4.0f, 22.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 15.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, -2.69f, 6.0f, -6.0f)
                reflectiveCurveToRelative(-2.69f, -6.0f, -6.0f, -6.0f)
                reflectiveCurveTo(6.0f, 5.69f, 6.0f, 9.0f)
                reflectiveCurveTo(8.69f, 15.0f, 12.0f, 15.0f)
                close()
                moveTo(12.0f, 5.0f)
                lineTo(12.0f, 5.0f)
                curveToRelative(0.38f, 0.0f, 0.71f, 0.23f, 0.85f, 0.59f)
                lineToRelative(2.12f, 5.65f)
                curveToRelative(0.14f, 0.37f, -0.13f, 0.76f, -0.53f, 0.76f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.24f, 0.0f, -0.45f, -0.15f, -0.53f, -0.38f)
                lineToRelative(-0.49f, -1.41f)
                horizontalLineToRelative(-2.83f)
                lineToRelative(-0.5f, 1.41f)
                curveTo(10.01f, 11.85f, 9.8f, 12.0f, 9.56f, 12.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.39f, 0.0f, -0.67f, -0.39f, -0.53f, -0.76f)
                lineToRelative(2.12f, -5.65f)
                curveTo(11.29f, 5.23f, 11.62f, 5.0f, 12.0f, 5.0f)
                close()
            }
            materialPath {
                moveTo(8.0f, 22.0f)
                lineTo(8.0f, 22.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveTo(7.0f, 21.55f, 7.45f, 22.0f, 8.0f, 22.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 22.0f)
                lineTo(12.0f, 22.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveTo(11.0f, 21.55f, 11.45f, 22.0f, 12.0f, 22.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 18.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(15.45f, 17.0f, 15.0f, 17.45f, 15.0f, 18.0f)
                close()
            }
        }
        return _autofpsSelect!!
    }

private var _autofpsSelect: ImageVector? = null
