/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AutoDelete: ImageVector
    get() {
        if (_autoDelete != null) {
            return _autoDelete!!
        }
        _autoDelete = materialIcon(name = "Rounded.AutoDelete") {
            materialPath {
                moveTo(16.0f, 9.0f)
                curveToRelative(-0.7f, 0.0f, -1.37f, 0.1f, -2.0f, 0.29f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 5.0f, 2.0f, 5.9f, 2.0f, 7.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(5.68f)
                curveToRelative(1.12f, 2.36f, 3.53f, 4.0f, 6.32f, 4.0f)
                curveToRelative(3.87f, 0.0f, 7.0f, -3.13f, 7.0f, -7.0f)
                curveTo(23.0f, 12.13f, 19.87f, 9.0f, 16.0f, 9.0f)
                close()
                moveTo(16.0f, 21.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                reflectiveCurveToRelative(2.24f, -5.0f, 5.0f, -5.0f)
                reflectiveCurveToRelative(5.0f, 2.24f, 5.0f, 5.0f)
                reflectiveCurveTo(18.76f, 21.0f, 16.0f, 21.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.5f)
                lineToRelative(-0.71f, -0.71f)
                curveTo(10.61f, 1.11f, 10.35f, 1.0f, 10.09f, 1.0f)
                horizontalLineTo(5.91f)
                curveTo(5.65f, 1.0f, 5.39f, 1.11f, 5.21f, 1.29f)
                lineTo(4.5f, 2.0f)
                horizontalLineTo(2.0f)
                curveTo(1.45f, 2.0f, 1.0f, 2.45f, 1.0f, 3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(14.0f)
                close()
            }
            materialPath {
                moveTo(15.75f, 12.0f)
                lineTo(15.75f, 12.0f)
                curveTo(15.34f, 12.0f, 15.0f, 12.34f, 15.0f, 12.75f)
                verticalLineToRelative(3.68f)
                curveToRelative(0.0f, 0.36f, 0.19f, 0.68f, 0.5f, 0.86f)
                lineToRelative(2.52f, 1.47f)
                curveToRelative(0.33f, 0.19f, 0.75f, 0.09f, 0.96f, -0.22f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.23f, -0.34f, 0.12f, -0.81f, -0.24f, -1.02f)
                lineTo(16.5f, 16.2f)
                verticalLineToRelative(-3.45f)
                curveTo(16.5f, 12.34f, 16.16f, 12.0f, 15.75f, 12.0f)
                close()
            }
        }
        return _autoDelete!!
    }

private var _autoDelete: ImageVector? = null
