/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AttachMoney: ImageVector
    get() {
        if (_attachMoney != null) {
            return _attachMoney!!
        }
        _attachMoney = materialIcon(name = "Rounded.AttachMoney") {
            materialPath {
                moveTo(11.8f, 10.9f)
                curveToRelative(-2.27f, -0.59f, -3.0f, -1.2f, -3.0f, -2.15f)
                curveToRelative(0.0f, -1.09f, 1.01f, -1.85f, 2.7f, -1.85f)
                curveToRelative(1.42f, 0.0f, 2.13f, 0.54f, 2.39f, 1.4f)
                curveToRelative(0.12f, 0.4f, 0.45f, 0.7f, 0.87f, 0.7f)
                horizontalLineToRelative(0.3f)
                curveToRelative(0.66f, 0.0f, 1.13f, -0.65f, 0.9f, -1.27f)
                curveToRelative(-0.42f, -1.18f, -1.4f, -2.16f, -2.96f, -2.54f)
                verticalLineTo(4.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                reflectiveCurveTo(10.0f, 3.67f, 10.0f, 4.5f)
                verticalLineToRelative(0.66f)
                curveToRelative(-1.94f, 0.42f, -3.5f, 1.68f, -3.5f, 3.61f)
                curveToRelative(0.0f, 2.31f, 1.91f, 3.46f, 4.7f, 4.13f)
                curveToRelative(2.5f, 0.6f, 3.0f, 1.48f, 3.0f, 2.41f)
                curveToRelative(0.0f, 0.69f, -0.49f, 1.79f, -2.7f, 1.79f)
                curveToRelative(-1.65f, 0.0f, -2.5f, -0.59f, -2.83f, -1.43f)
                curveToRelative(-0.15f, -0.39f, -0.49f, -0.67f, -0.9f, -0.67f)
                horizontalLineToRelative(-0.28f)
                curveToRelative(-0.67f, 0.0f, -1.14f, 0.68f, -0.89f, 1.3f)
                curveToRelative(0.57f, 1.39f, 1.9f, 2.21f, 3.4f, 2.53f)
                verticalLineToRelative(0.67f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveToRelative(1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-0.65f)
                curveToRelative(1.95f, -0.37f, 3.5f, -1.5f, 3.5f, -3.55f)
                curveToRelative(0.0f, -2.84f, -2.43f, -3.81f, -4.7f, -4.4f)
                close()
            }
        }
        return _attachMoney!!
    }

private var _attachMoney: ImageVector? = null
