/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AlignVerticalCenter: ImageVector
    get() {
        if (_alignVerticalCenter != null) {
            return _alignVerticalCenter!!
        }
        _alignVerticalCenter = materialIcon(name = "Rounded.AlignVerticalCenter") {
            materialPath {
                moveTo(21.0f, 11.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(7.5f)
                curveTo(17.0f, 6.67f, 16.33f, 6.0f, 15.5f, 6.0f)
                horizontalLineToRelative(0.0f)
                curveTo(14.67f, 6.0f, 14.0f, 6.67f, 14.0f, 7.5f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(4.5f)
                curveTo(10.0f, 3.67f, 9.33f, 3.0f, 8.5f, 3.0f)
                horizontalLineToRelative(0.0f)
                curveTo(7.67f, 3.0f, 7.0f, 3.67f, 7.0f, 4.5f)
                verticalLineTo(11.0f)
                horizontalLineTo(2.84f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(6.5f)
                curveTo(7.0f, 20.33f, 7.67f, 21.0f, 8.5f, 21.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(3.5f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveTo(22.0f, 11.45f, 21.55f, 11.0f, 21.0f, 11.0f)
                close()
            }
        }
        return _alignVerticalCenter!!
    }

private var _alignVerticalCenter: ImageVector? = null
