/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined._8k: ImageVector
    get() {
        if (__8k != null) {
            return __8k!!
        }
        __8k = materialIcon(name = "Outlined._8k") {
            materialPath {
                moveTo(7.5f, 15.0f)
                horizontalLineTo(10.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(7.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveTo(6.5f, 14.55f, 6.95f, 15.0f, 7.5f, 15.0f)
                close()
                moveTo(8.0f, 10.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(1.5f)
                horizontalLineTo(8.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(8.0f, 12.5f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(14.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(12.5f)
                close()
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(19.0f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(14.5f, 12.75f)
                lineToRelative(1.75f, 2.25f)
                lineToRelative(1.75f, 0.0f)
                lineToRelative(-2.25f, -3.0f)
                lineToRelative(2.25f, -3.0f)
                lineToRelative(-1.75f, 0.0f)
                lineToRelative(-1.75f, 2.25f)
                lineToRelative(0.0f, -2.25f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(1.5f, 0.0f)
                close()
            }
        }
        return __8k!!
    }

private var __8k: ImageVector? = null
