/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TypeSpecimen: ImageVector
    get() {
        if (_typeSpecimen != null) {
            return _typeSpecimen!!
        }
        _typeSpecimen = materialIcon(name = "Outlined.TypeSpecimen") {
            materialPath {
                moveTo(4.0f, 6.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(6.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(8.0f)
                curveTo(6.9f, 2.0f, 6.0f, 2.9f, 6.0f, 4.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(20.0f, 16.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(12.19f, 12.2f)
                horizontalLineToRelative(3.63f)
                lineToRelative(0.8f, 2.3f)
                horizontalLineToRelative(1.56f)
                lineToRelative(-3.38f, -9.0f)
                horizontalLineTo(13.2f)
                lineToRelative(-3.38f, 9.0f)
                horizontalLineToRelative(1.56f)
                lineTo(12.19f, 12.2f)
                close()
                moveTo(13.96f, 7.17f)
                horizontalLineToRelative(0.08f)
                lineToRelative(1.31f, 3.72f)
                horizontalLineToRelative(-2.69f)
                lineTo(13.96f, 7.17f)
                close()
            }
        }
        return _typeSpecimen!!
    }

private var _typeSpecimen: ImageVector? = null
