/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TableRestaurant: ImageVector
    get() {
        if (_tableRestaurant != null) {
            return _tableRestaurant!!
        }
        _tableRestaurant = materialIcon(name = "Outlined.TableRestaurant") {
            materialPath {
                moveTo(21.96f, 9.73f)
                lineToRelative(-1.43f, -5.0f)
                curveTo(20.41f, 4.3f, 20.02f, 4.0f, 19.57f, 4.0f)
                horizontalLineTo(4.43f)
                curveTo(3.98f, 4.0f, 3.59f, 4.3f, 3.47f, 4.73f)
                lineToRelative(-1.43f, 5.0f)
                curveTo(1.86f, 10.36f, 2.34f, 11.0f, 3.0f, 11.0f)
                horizontalLineToRelative(2.2f)
                lineTo(4.0f, 20.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(0.67f, -5.0f)
                horizontalLineToRelative(10.67f)
                lineTo(18.0f, 20.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(-1.2f, -9.0f)
                horizontalLineTo(21.0f)
                curveTo(21.66f, 11.0f, 22.14f, 10.36f, 21.96f, 9.73f)
                close()
                moveTo(6.93f, 13.0f)
                lineToRelative(0.27f, -2.0f)
                horizontalLineToRelative(9.6f)
                lineToRelative(0.27f, 2.0f)
                horizontalLineTo(6.93f)
                close()
                moveTo(4.33f, 9.0f)
                lineToRelative(0.86f, -3.0f)
                horizontalLineToRelative(13.63f)
                lineToRelative(0.86f, 3.0f)
                horizontalLineTo(4.33f)
                close()
            }
        }
        return _tableRestaurant!!
    }

private var _tableRestaurant: ImageVector? = null
