/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SupervisedUserCircle: ImageVector
    get() {
        if (_supervisedUserCircle != null) {
            return _supervisedUserCircle!!
        }
        _supervisedUserCircle = materialIcon(name = "Outlined.SupervisedUserCircle") {
            materialPath {
                moveTo(12.5f, 10.0f)
                curveToRelative(0.0f, -1.65f, -1.35f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.35f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.35f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.35f, 3.0f, -3.0f)
                close()
                moveTo(9.5f, 11.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
                moveTo(16.0f, 13.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -2.0f)
                curveToRelative(-1.11f, 0.0f, -2.01f, 0.89f, -2.0f, 2.0f)
                curveToRelative(0.0f, 1.11f, 0.89f, 2.0f, 2.0f, 2.0f)
                close()
                moveTo(11.99f, 2.01f)
                curveToRelative(-5.52f, 0.0f, -10.0f, 4.48f, -10.0f, 10.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveToRelative(-4.48f, -10.0f, -10.0f, -10.0f)
                close()
                moveTo(5.84f, 17.12f)
                curveToRelative(0.68f, -0.54f, 2.27f, -1.11f, 3.66f, -1.11f)
                curveToRelative(0.07f, 0.0f, 0.15f, 0.01f, 0.23f, 0.01f)
                curveToRelative(0.24f, -0.64f, 0.67f, -1.29f, 1.3f, -1.86f)
                curveToRelative(-0.56f, -0.1f, -1.09f, -0.16f, -1.53f, -0.16f)
                curveToRelative(-1.3f, 0.0f, -3.39f, 0.45f, -4.73f, 1.43f)
                curveToRelative(-0.5f, -1.04f, -0.78f, -2.2f, -0.78f, -3.43f)
                curveToRelative(0.0f, -4.41f, 3.59f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.59f, 8.0f, 8.0f)
                curveToRelative(0.0f, 1.2f, -0.27f, 2.34f, -0.75f, 3.37f)
                curveToRelative(-1.0f, -0.59f, -2.36f, -0.87f, -3.24f, -0.87f)
                curveToRelative(-1.52f, 0.0f, -4.5f, 0.81f, -4.5f, 2.7f)
                verticalLineToRelative(2.78f)
                curveToRelative(-2.27f, -0.13f, -4.29f, -1.21f, -5.66f, -2.86f)
                close()
            }
        }
        return _supervisedUserCircle!!
    }

private var _supervisedUserCircle: ImageVector? = null
