/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SportsFootball: ImageVector
    get() {
        if (_sportsFootball != null) {
            return _sportsFootball!!
        }
        _sportsFootball = materialIcon(name = "Outlined.SportsFootball") {
            materialPath {
                moveTo(20.31f, 3.69f)
                curveTo(19.99f, 3.36f, 18.37f, 3.0f, 16.26f, 3.0f)
                curveToRelative(-3.03f, 0.0f, -7.09f, 0.75f, -9.8f, 3.46f)
                curveTo(1.87f, 11.05f, 2.9f, 19.52f, 3.69f, 20.31f)
                curveTo(4.01f, 20.64f, 5.63f, 21.0f, 7.74f, 21.0f)
                curveToRelative(3.03f, 0.0f, 7.09f, -0.75f, 9.8f, -3.46f)
                curveTo(22.13f, 12.95f, 21.1f, 4.48f, 20.31f, 3.69f)
                close()
                moveTo(7.74f, 19.0f)
                curveToRelative(-1.14f, 0.0f, -2.02f, -0.12f, -2.53f, -0.23f)
                curveToRelative(-0.18f, -0.79f, -0.3f, -2.21f, -0.17f, -3.83f)
                lineToRelative(4.01f, 4.01f)
                curveTo(8.53f, 18.99f, 8.08f, 19.0f, 7.74f, 19.0f)
                close()
                moveTo(16.13f, 16.13f)
                curveToRelative(-1.33f, 1.33f, -3.06f, 2.05f, -4.66f, 2.44f)
                lineToRelative(-6.04f, -6.04f)
                curveToRelative(0.42f, -1.68f, 1.16f, -3.37f, 2.45f, -4.65f)
                curveToRelative(1.32f, -1.32f, 3.05f, -2.04f, 4.64f, -2.43f)
                lineToRelative(6.05f, 6.05f)
                curveTo(18.15f, 13.17f, 17.4f, 14.85f, 16.13f, 16.13f)
                close()
                moveTo(18.96f, 9.09f)
                lineToRelative(-4.03f, -4.03f)
                curveTo(15.45f, 5.01f, 15.91f, 5.0f, 16.26f, 5.0f)
                curveToRelative(1.14f, 0.0f, 2.02f, 0.12f, 2.53f, 0.23f)
                curveTo(18.97f, 6.02f, 19.09f, 7.45f, 18.96f, 9.09f)
                close()
            }
            materialPath {
                moveTo(8.5f, 14.1f)
                lineToRelative(5.6f, -5.6f)
                lineToRelative(1.4f, 1.4f)
                lineToRelative(-5.6f, 5.6f)
                close()
            }
        }
        return _sportsFootball!!
    }

private var _sportsFootball: ImageVector? = null
