/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SolarPower: ImageVector
    get() {
        if (_solarPower != null) {
            return _solarPower!!
        }
        _solarPower = materialIcon(name = "Outlined.SolarPower") {
            materialPath {
                moveTo(20.0f, 12.0f)
                horizontalLineTo(4.0f)
                lineTo(2.0f, 22.0f)
                horizontalLineToRelative(20.0f)
                lineTo(20.0f, 12.0f)
                close()
                moveTo(18.36f, 14.0f)
                lineToRelative(0.4f, 2.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(18.36f)
                close()
                moveTo(11.0f, 14.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(5.24f)
                lineToRelative(0.4f, -2.0f)
                horizontalLineTo(11.0f)
                close()
                moveTo(4.84f, 18.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.44f)
                lineTo(4.84f, 18.0f)
                close()
                moveTo(13.0f, 20.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(6.16f)
                lineToRelative(0.4f, 2.0f)
                horizontalLineTo(13.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(15.764f, 7.205f)
                lineToRelative(1.414f, -1.414f)
                lineToRelative(2.121f, 2.121f)
                lineToRelative(-1.414f, 1.414f)
                close()
            }
            materialPath {
                moveTo(4.705f, 7.913f)
                lineToRelative(2.121f, -2.121f)
                lineToRelative(1.414f, 1.414f)
                lineToRelative(-2.121f, 2.121f)
                close()
            }
            materialPath {
                moveTo(3.0f, 2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 7.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, 1.65f, -1.35f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveTo(9.0f, 3.65f, 9.0f, 2.0f)
                horizontalLineTo(7.0f)
                curveTo(7.0f, 4.76f, 9.24f, 7.0f, 12.0f, 7.0f)
                close()
            }
        }
        return _solarPower!!
    }

private var _solarPower: ImageVector? = null
