/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.RemoveRoad: ImageVector
    get() {
        if (_removeRoad != null) {
            return _removeRoad!!
        }
        _removeRoad = materialIcon(name = "Outlined.RemoveRoad") {
            materialPath {
                moveTo(18.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(9.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 16.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(22.5f, 16.41f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-2.09f, 2.09f)
                lineToRelative(-2.09f, -2.09f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(2.09f, 2.09f)
                lineToRelative(-2.09f, 2.09f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(2.09f, -2.09f)
                lineToRelative(2.09f, 2.09f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-2.09f, -2.09f)
                close()
            }
        }
        return _removeRoad!!
    }

private var _removeRoad: ImageVector? = null
