/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.LowPriority: ImageVector
    get() {
        if (_lowPriority != null) {
            return _lowPriority!!
        }
        _lowPriority = materialIcon(name = "Outlined.LowPriority") {
            materialPath {
                moveTo(14.0f, 5.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-8.0f)
                lineTo(14.0f, 5.0f)
                close()
                moveTo(14.0f, 10.5f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(14.0f, 16.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(2.0f, 11.5f)
                curveTo(2.0f, 15.08f, 4.92f, 18.0f, 8.5f, 18.0f)
                lineTo(9.0f, 18.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(3.0f, -3.0f)
                lineToRelative(-3.0f, -3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-0.5f)
                curveTo(6.02f, 16.0f, 4.0f, 13.98f, 4.0f, 11.5f)
                reflectiveCurveTo(6.02f, 7.0f, 8.5f, 7.0f)
                lineTo(12.0f, 7.0f)
                lineTo(12.0f, 5.0f)
                lineTo(8.5f, 5.0f)
                curveTo(4.92f, 5.0f, 2.0f, 7.92f, 2.0f, 11.5f)
                close()
            }
        }
        return _lowPriority!!
    }

private var _lowPriority: ImageVector? = null
