/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FormatTextdirectionLToR: ImageVector
    get() {
        if (_formatTextdirectionLToR != null) {
            return _formatTextdirectionLToR!!
        }
        _formatTextdirectionLToR = materialIcon(name = "Outlined.FormatTextdirectionLToR") {
            materialPath {
                moveTo(9.0f, 4.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                moveToRelative(8.0f, -2.0f)
                lineTo(9.0f, 2.0f)
                curveTo(6.79f, 2.0f, 5.0f, 3.79f, 5.0f, 6.0f)
                reflectiveCurveToRelative(1.79f, 4.0f, 4.0f, 4.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                lineTo(11.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(2.0f)
                lineTo(15.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                lineTo(17.0f, 2.0f)
                close()
                moveTo(17.0f, 14.0f)
                verticalLineToRelative(3.0f)
                lineTo(5.0f, 17.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(3.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(-4.0f, -4.0f)
                close()
            }
        }
        return _formatTextdirectionLToR!!
    }

private var _formatTextdirectionLToR: ImageVector? = null
