/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Flood: ImageVector
    get() {
        if (_flood != null) {
            return _flood!!
        }
        _flood = materialIcon(name = "Outlined.Flood") {
            materialPath {
                moveTo(18.67f, 19.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.1f, 1.0f, -3.34f, 1.0f)
                curveToRelative(-1.24f, 0.0f, -1.38f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.1f, 1.0f, -3.34f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(1.95f, 0.0f, 2.11f, -1.0f, 3.34f, -1.0f)
                curveToRelative(1.24f, 0.0f, 1.38f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.1f, -1.0f, 3.34f, -1.0f)
                curveToRelative(1.22f, 0.0f, 1.4f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.93f, 0.0f, 2.1f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.22f, 0.0f, 1.4f, 1.0f, 3.33f, 1.0f)
                verticalLineToRelative(-2.0f)
                curveTo(20.76f, 20.0f, 20.62f, 19.0f, 18.67f, 19.0f)
                close()
            }
            materialPath {
                moveTo(8.68f, 17.5f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.4f, 0.98f, 3.31f, 1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-0.63f, 0.0f, -1.0f, -0.28f, -1.48f, -0.55f)
                lineToRelative(-2.02f, -7.53f)
                lineToRelative(2.09f, 0.85f)
                lineToRelative(0.74f, -1.86f)
                lineTo(9.78f, 2.0f)
                lineTo(2.0f, 11.61f)
                lineToRelative(1.57f, 1.23f)
                lineToRelative(1.39f, -1.78f)
                lineToRelative(0.93f, 3.48f)
                curveToRelative(-0.18f, -0.02f, -0.35f, -0.05f, -0.56f, -0.05f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(1.9f, 0.0f, 2.17f, -1.0f, 3.35f, -1.0f)
                curveTo(6.54f, 16.5f, 6.77f, 17.5f, 8.68f, 17.5f)
                close()
                moveTo(10.42f, 4.41f)
                lineToRelative(5.74f, 2.09f)
                lineToRelative(2.15f, 8.02f)
                curveToRelative(-1.54f, 0.11f, -1.82f, 0.89f, -2.85f, 0.96f)
                lineToRelative(-1.42f, -5.31f)
                lineToRelative(-3.86f, 1.04f)
                lineToRelative(0.91f, 3.39f)
                curveToRelative(-1.12f, 0.25f, -1.41f, 0.9f, -2.42f, 0.9f)
                curveToRelative(-0.18f, 0.0f, -0.33f, -0.02f, -0.45f, -0.05f)
                lineTo(6.5f, 9.09f)
                lineTo(10.42f, 4.41f)
                close()
            }
        }
        return _flood!!
    }

private var _flood: ImageVector? = null
