/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Face3: ImageVector
    get() {
        if (_face3 != null) {
            return _face3!!
        }
        _face3 = materialIcon(name = "Outlined.Face3") {
            materialPath {
                moveTo(9.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(22.91f, 11.96f)
                curveTo(22.39f, 6.32f, 17.66f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveTo(1.61f, 6.32f, 1.09f, 11.96f)
                lineToRelative(-0.9f, 9.86f)
                curveTo(0.09f, 22.99f, 1.01f, 24.0f, 2.19f, 24.0f)
                horizontalLineToRelative(19.62f)
                curveToRelative(1.18f, 0.0f, 2.1f, -1.01f, 1.99f, -2.18f)
                lineTo(22.91f, 11.96f)
                close()
                moveTo(13.0f, 4.07f)
                curveToRelative(2.26f, 0.28f, 4.22f, 1.51f, 5.49f, 3.28f)
                curveTo(17.91f, 7.75f, 17.23f, 8.0f, 16.5f, 8.0f)
                curveTo(14.57f, 8.0f, 13.0f, 6.43f, 13.0f, 4.5f)
                verticalLineTo(4.07f)
                close()
                moveTo(11.0f, 4.07f)
                verticalLineTo(4.5f)
                curveTo(11.0f, 6.43f, 9.43f, 8.0f, 7.5f, 8.0f)
                curveTo(6.77f, 8.0f, 6.09f, 7.75f, 5.51f, 7.35f)
                curveTo(6.78f, 5.58f, 8.74f, 4.35f, 11.0f, 4.07f)
                close()
                moveTo(4.54f, 9.13f)
                curveTo(5.41f, 9.68f, 6.43f, 10.0f, 7.5f, 10.0f)
                curveTo(9.36f, 10.0f, 11.0f, 9.07f, 12.0f, 7.65f)
                curveTo(13.0f, 9.07f, 14.64f, 10.0f, 16.5f, 10.0f)
                curveToRelative(1.07f, 0.0f, 2.09f, -0.32f, 2.96f, -0.87f)
                curveTo(19.8f, 10.02f, 20.0f, 10.99f, 20.0f, 12.0f)
                curveToRelative(0.0f, 4.41f, -3.59f, 8.0f, -8.0f, 8.0f)
                reflectiveCurveToRelative(-8.0f, -3.59f, -8.0f, -8.0f)
                curveTo(4.0f, 10.99f, 4.2f, 10.02f, 4.54f, 9.13f)
                close()
                moveTo(12.0f, 22.0f)
                horizontalLineTo(2.19f)
                lineToRelative(0.56f, -6.2f)
                curveTo(4.25f, 19.44f, 7.82f, 22.0f, 12.0f, 22.0f)
                reflectiveCurveToRelative(7.75f, -2.56f, 9.25f, -6.2f)
                lineToRelative(0.56f, 6.2f)
                horizontalLineTo(12.0f)
                close()
            }
        }
        return _face3!!
    }

private var _face3: ImageVector? = null
