/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Diamond: ImageVector
    get() {
        if (_diamond != null) {
            return _diamond!!
        }
        _diamond = materialIcon(name = "Outlined.Diamond") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                lineTo(2.0f, 9.0f)
                lineToRelative(10.0f, 12.0f)
                lineTo(22.0f, 9.0f)
                lineTo(19.0f, 3.0f)
                close()
                moveTo(9.62f, 8.0f)
                lineToRelative(1.5f, -3.0f)
                horizontalLineToRelative(1.76f)
                lineToRelative(1.5f, 3.0f)
                horizontalLineTo(9.62f)
                close()
                moveTo(11.0f, 10.0f)
                verticalLineToRelative(6.68f)
                lineTo(5.44f, 10.0f)
                horizontalLineTo(11.0f)
                close()
                moveTo(13.0f, 10.0f)
                horizontalLineToRelative(5.56f)
                lineTo(13.0f, 16.68f)
                verticalLineTo(10.0f)
                close()
                moveTo(19.26f, 8.0f)
                horizontalLineToRelative(-2.65f)
                lineToRelative(-1.5f, -3.0f)
                horizontalLineToRelative(2.65f)
                lineTo(19.26f, 8.0f)
                close()
                moveTo(6.24f, 5.0f)
                horizontalLineToRelative(2.65f)
                lineToRelative(-1.5f, 3.0f)
                horizontalLineTo(4.74f)
                lineTo(6.24f, 5.0f)
                close()
            }
        }
        return _diamond!!
    }

private var _diamond: ImageVector? = null
