/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DataThresholding: ImageVector
    get() {
        if (_dataThresholding != null) {
            return _dataThresholding!!
        }
        _dataThresholding = materialIcon(name = "Outlined.DataThresholding") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(19.0f, 19.0f)
                horizontalLineToRelative(-1.73f)
                lineTo(19.0f, 17.27f)
                verticalLineTo(19.0f)
                close()
                moveTo(19.0f, 16.0f)
                horizontalLineToRelative(-0.85f)
                lineToRelative(-3.0f, 3.0f)
                horizontalLineToRelative(-1.62f)
                lineToRelative(3.0f, -3.0f)
                horizontalLineToRelative(-2.12f)
                lineToRelative(-3.0f, 3.0f)
                horizontalLineTo(9.8f)
                lineToRelative(3.0f, -3.0f)
                horizontalLineToRelative(-2.12f)
                lineToRelative(-3.0f, 3.0f)
                horizontalLineTo(5.84f)
                lineToRelative(3.0f, -3.0f)
                horizontalLineTo(6.72f)
                lineTo(5.0f, 17.72f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(10.67f, 11.0f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(5.08f, -5.09f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-3.67f, 3.67f)
                lineToRelative(-2.0f, -2.0f)
                lineToRelative(-4.42f, 4.42f)
                lineToRelative(1.41f, 1.41f)
                close()
            }
        }
        return _dataThresholding!!
    }

private var _dataThresholding: ImageVector? = null
