/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.CrueltyFree: ImageVector
    get() {
        if (_crueltyFree != null) {
            return _crueltyFree!!
        }
        _crueltyFree = materialIcon(name = "Outlined.CrueltyFree") {
            materialPath {
                moveTo(17.0f, 14.0f)
                curveToRelative(-0.24f, -0.24f, -0.44f, -0.49f, -0.65f, -0.75f)
                curveTo(17.51f, 11.5f, 19.0f, 8.56f, 19.0f, 5.0f)
                curveToRelative(0.0f, -1.95f, -0.74f, -3.0f, -2.0f, -3.0f)
                curveToRelative(-1.54f, 0.0f, -3.96f, 2.06f, -5.0f, 5.97f)
                curveTo(10.96f, 4.06f, 8.54f, 2.0f, 7.0f, 2.0f)
                curveTo(5.74f, 2.0f, 5.0f, 3.05f, 5.0f, 5.0f)
                curveToRelative(0.0f, 3.56f, 1.49f, 6.5f, 2.65f, 8.25f)
                curveTo(7.44f, 13.51f, 7.24f, 13.76f, 7.0f, 14.0f)
                curveToRelative(-0.25f, 0.25f, -2.0f, 1.39f, -2.0f, 3.5f)
                curveTo(5.0f, 19.98f, 7.02f, 22.0f, 9.5f, 22.0f)
                curveToRelative(1.5f, 0.0f, 2.5f, -0.5f, 2.5f, -0.5f)
                reflectiveCurveToRelative(1.0f, 0.5f, 2.5f, 0.5f)
                curveToRelative(2.48f, 0.0f, 4.5f, -2.02f, 4.5f, -4.5f)
                curveTo(19.0f, 15.39f, 17.25f, 14.25f, 17.0f, 14.0f)
                close()
                moveTo(16.88f, 4.03f)
                curveTo(16.94f, 4.2f, 17.0f, 4.51f, 17.0f, 5.0f)
                curveToRelative(0.0f, 2.84f, -1.11f, 5.24f, -2.07f, 6.78f)
                curveToRelative(-0.38f, -0.26f, -0.83f, -0.48f, -1.4f, -0.62f)
                curveTo(13.77f, 6.64f, 15.97f, 4.33f, 16.88f, 4.03f)
                close()
                moveTo(7.0f, 5.0f)
                curveToRelative(0.0f, -0.49f, 0.06f, -0.8f, 0.12f, -0.97f)
                curveToRelative(0.91f, 0.3f, 3.11f, 2.61f, 3.36f, 7.13f)
                curveToRelative(-0.58f, 0.14f, -1.03f, 0.35f, -1.4f, 0.62f)
                curveTo(8.11f, 10.24f, 7.0f, 7.84f, 7.0f, 5.0f)
                close()
                moveTo(14.5f, 20.0f)
                curveToRelative(-1.0f, 0.0f, -1.8f, -0.33f, -2.22f, -0.56f)
                curveTo(12.7f, 19.26f, 13.0f, 18.73f, 13.0f, 18.5f)
                curveToRelative(0.0f, -0.28f, -0.45f, -0.5f, -1.0f, -0.5f)
                reflectiveCurveToRelative(-1.0f, 0.22f, -1.0f, 0.5f)
                curveToRelative(0.0f, 0.23f, 0.3f, 0.76f, 0.72f, 0.94f)
                curveTo(11.3f, 19.67f, 10.5f, 20.0f, 9.5f, 20.0f)
                curveTo(8.12f, 20.0f, 7.0f, 18.88f, 7.0f, 17.5f)
                curveToRelative(0.0f, -0.7f, 0.43f, -1.24f, 1.0f, -1.73f)
                curveToRelative(0.44f, -0.36f, 0.61f, -0.52f, 1.3f, -1.37f)
                curveToRelative(0.76f, -0.95f, 1.09f, -1.4f, 2.7f, -1.4f)
                reflectiveCurveToRelative(1.94f, 0.45f, 2.7f, 1.4f)
                curveToRelative(0.69f, 0.85f, 0.86f, 1.01f, 1.3f, 1.37f)
                curveToRelative(0.57f, 0.49f, 1.0f, 1.03f, 1.0f, 1.73f)
                curveTo(17.0f, 18.88f, 15.88f, 20.0f, 14.5f, 20.0f)
                close()
                moveTo(14.0f, 16.0f)
                curveToRelative(0.0f, 0.41f, -0.22f, 0.75f, -0.5f, 0.75f)
                reflectiveCurveTo(13.0f, 16.41f, 13.0f, 16.0f)
                curveToRelative(0.0f, -0.41f, 0.22f, -0.75f, 0.5f, -0.75f)
                reflectiveCurveTo(14.0f, 15.59f, 14.0f, 16.0f)
                close()
                moveTo(11.0f, 16.0f)
                curveToRelative(0.0f, 0.41f, -0.22f, 0.75f, -0.5f, 0.75f)
                reflectiveCurveTo(10.0f, 16.41f, 10.0f, 16.0f)
                curveToRelative(0.0f, -0.41f, 0.22f, -0.75f, 0.5f, -0.75f)
                reflectiveCurveTo(11.0f, 15.59f, 11.0f, 16.0f)
                close()
            }
        }
        return _crueltyFree!!
    }

private var _crueltyFree: ImageVector? = null
