/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ContactPhone: ImageVector
    get() {
        if (_contactPhone != null) {
            return _contactPhone!!
        }
        _contactPhone = materialIcon(name = "Outlined.ContactPhone") {
            materialPath {
                moveTo(22.0f, 3.0f)
                lineTo(2.0f, 3.0f)
                curveTo(0.9f, 3.0f, 0.0f, 3.9f, 0.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(20.0f)
                curveToRelative(1.1f, 0.0f, 1.99f, -0.9f, 1.99f, -2.0f)
                lineTo(24.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(22.0f, 19.0f)
                lineTo(2.0f, 19.0f)
                lineTo(2.0f, 5.0f)
                horizontalLineToRelative(20.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(19.01f, 17.99f)
                lineTo(21.0f, 16.0f)
                lineToRelative(-1.51f, -2.0f)
                horizontalLineToRelative(-1.64f)
                curveToRelative(-0.22f, -0.63f, -0.35f, -1.3f, -0.35f, -2.0f)
                reflectiveCurveToRelative(0.13f, -1.37f, 0.35f, -2.0f)
                horizontalLineToRelative(1.64f)
                lineTo(21.0f, 8.0f)
                lineToRelative(-1.99f, -1.99f)
                curveToRelative(-1.31f, 0.98f, -2.28f, 2.37f, -2.73f, 3.99f)
                curveToRelative(-0.18f, 0.64f, -0.28f, 1.31f, -0.28f, 2.0f)
                reflectiveCurveToRelative(0.1f, 1.36f, 0.28f, 2.0f)
                curveToRelative(0.45f, 1.61f, 1.42f, 3.01f, 2.73f, 3.99f)
                close()
                moveTo(9.0f, 12.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, -1.35f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.35f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.35f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.35f, 3.0f, 3.0f, 3.0f)
                close()
                moveTo(9.0f, 8.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                close()
                moveTo(15.0f, 16.59f)
                curveToRelative(0.0f, -2.5f, -3.97f, -3.58f, -6.0f, -3.58f)
                reflectiveCurveToRelative(-6.0f, 1.08f, -6.0f, 3.58f)
                lineTo(3.0f, 18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-1.41f)
                close()
                moveTo(5.48f, 16.0f)
                curveToRelative(0.74f, -0.5f, 2.22f, -1.0f, 3.52f, -1.0f)
                reflectiveCurveToRelative(2.77f, 0.49f, 3.52f, 1.0f)
                lineTo(5.48f, 16.0f)
                close()
            }
        }
        return _contactPhone!!
    }

private var _contactPhone: ImageVector? = null
