/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TextRotationAngleup: ImageVector
    get() {
        if (_textRotationAngleup != null) {
            return _textRotationAngleup!!
        }
        _textRotationAngleup = materialIcon(name = "Filled.TextRotationAngleup") {
            materialPath {
                moveTo(4.49f, 4.21f)
                lineTo(3.43f, 5.27f)
                lineTo(7.85f, 16.4f)
                lineToRelative(1.48f, -1.48f)
                lineToRelative(-0.92f, -2.19f)
                lineToRelative(3.54f, -3.54f)
                lineToRelative(2.19f, 0.92f)
                lineToRelative(1.48f, -1.48f)
                lineTo(4.49f, 4.21f)
                close()
                moveTo(7.58f, 11.01f)
                lineTo(5.36f, 6.14f)
                lineToRelative(4.87f, 2.23f)
                lineToRelative(-2.65f, 2.64f)
                close()
                moveTo(20.57f, 9.33f)
                horizontalLineToRelative(-4.24f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-8.84f, 8.84f)
                lineTo(10.32f, 21.0f)
                lineToRelative(8.84f, -8.84f)
                lineToRelative(1.41f, 1.41f)
                lineTo(20.57f, 9.33f)
                close()
            }
        }
        return _textRotationAngleup!!
    }

private var _textRotationAngleup: ImageVector? = null
