/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.StopScreenShare: ImageVector
    get() {
        if (_stopScreenShare != null) {
            return _stopScreenShare!!
        }
        _stopScreenShare = materialIcon(name = "Filled.StopScreenShare") {
            materialPath {
                moveTo(21.22f, 18.02f)
                lineToRelative(2.0f, 2.0f)
                lineTo(24.0f, 20.02f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.78f)
                close()
                moveTo(21.99f, 16.02f)
                lineToRelative(0.01f, -10.0f)
                curveToRelative(0.0f, -1.11f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(7.22f, 4.02f)
                lineToRelative(5.23f, 5.23f)
                curveToRelative(0.18f, -0.04f, 0.36f, -0.07f, 0.55f, -0.1f)
                lineTo(13.0f, 7.02f)
                lineToRelative(4.0f, 3.73f)
                lineToRelative(-1.58f, 1.47f)
                lineToRelative(5.54f, 5.54f)
                curveToRelative(0.61f, -0.33f, 1.03f, -0.99f, 1.03f, -1.74f)
                close()
                moveTo(2.39f, 1.73f)
                lineTo(1.11f, 3.0f)
                lineToRelative(1.54f, 1.54f)
                curveToRelative(-0.4f, 0.36f, -0.65f, 0.89f, -0.65f, 1.48f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                lineTo(0.0f, 18.02f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(18.13f)
                lineToRelative(2.71f, 2.71f)
                lineToRelative(1.27f, -1.27f)
                lineTo(2.39f, 1.73f)
                close()
                moveTo(7.0f, 15.02f)
                curveToRelative(0.31f, -1.48f, 0.92f, -2.95f, 2.07f, -4.06f)
                lineToRelative(1.59f, 1.59f)
                curveToRelative(-1.54f, 0.38f, -2.7f, 1.18f, -3.66f, 2.47f)
                close()
            }
        }
        return _stopScreenShare!!
    }

private var _stopScreenShare: ImageVector? = null
