/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SpatialTracking: ImageVector
    get() {
        if (_spatialTracking != null) {
            return _spatialTracking!!
        }
        _spatialTracking = materialIcon(name = "Filled.SpatialTracking") {
            materialPath {
                moveTo(10.0f, 9.0f)
                moveToRelative(-4.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, 8.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, -8.0f, 0.0f)
            }
            materialPath {
                moveTo(16.39f, 15.56f)
                curveTo(14.71f, 14.7f, 12.53f, 14.0f, 10.0f, 14.0f)
                curveToRelative(-2.53f, 0.0f, -4.71f, 0.7f, -6.39f, 1.56f)
                curveTo(2.61f, 16.07f, 2.0f, 17.1f, 2.0f, 18.22f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.78f)
                curveTo(18.0f, 17.1f, 17.39f, 16.07f, 16.39f, 15.56f)
                close()
            }
            materialPath {
                moveTo(20.05f, 2.41f)
                lineTo(18.64f, 1.0f)
                curveToRelative(-3.51f, 3.51f, -3.51f, 9.21f, 0.0f, 12.73f)
                lineToRelative(1.41f, -1.41f)
                curveTo(17.32f, 9.58f, 17.32f, 5.14f, 20.05f, 2.41f)
                close()
            }
            materialPath {
                moveTo(22.88f, 5.24f)
                lineToRelative(-1.41f, -1.41f)
                curveToRelative(-1.95f, 1.95f, -1.95f, 5.12f, 0.0f, 7.07f)
                lineToRelative(1.41f, -1.41f)
                curveTo(21.71f, 8.32f, 21.71f, 6.41f, 22.88f, 5.24f)
                close()
            }
        }
        return _spatialTracking!!
    }

private var _spatialTracking: ImageVector? = null
