/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.RealEstateAgent: ImageVector
    get() {
        if (_realEstateAgent != null) {
            return _realEstateAgent!!
        }
        _realEstateAgent = materialIcon(name = "Filled.RealEstateAgent") {
            materialPath {
                moveTo(1.0f, 22.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(22.0f)
                close()
                moveTo(20.0f, 17.0f)
                horizontalLineToRelative(-7.0f)
                lineToRelative(-2.09f, -0.73f)
                lineToRelative(0.33f, -0.94f)
                lineTo(13.0f, 16.0f)
                horizontalLineToRelative(2.82f)
                curveToRelative(0.65f, 0.0f, 1.18f, -0.53f, 1.18f, -1.18f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.49f, -0.31f, -0.93f, -0.77f, -1.11f)
                lineTo(8.97f, 11.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(9.02f)
                lineTo(14.0f, 22.0f)
                lineToRelative(8.0f, -3.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(21.99f, 17.9f, 21.11f, 17.0f, 20.0f, 17.0f)
                close()
                moveTo(14.0f, 1.5f)
                lineToRelative(-7.0f, 5.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(8.14f, 3.26f)
                curveTo(18.26f, 12.71f, 19.0f, 13.79f, 19.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.5f)
                lineTo(14.0f, 1.5f)
                close()
                moveTo(13.5f, 10.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(13.5f, 8.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(8.0f)
                close()
                moveTo(15.5f, 10.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(15.5f, 8.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(8.0f)
                close()
            }
        }
        return _realEstateAgent!!
    }

private var _realEstateAgent: ImageVector? = null
