/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PhonelinkSetup: ImageVector
    get() {
        if (_phonelinkSetup != null) {
            return _phonelinkSetup!!
        }
        _phonelinkSetup = materialIcon(name = "Filled.PhonelinkSetup") {
            materialPath {
                moveTo(10.82f, 12.49f)
                curveToRelative(0.02f, -0.16f, 0.04f, -0.32f, 0.04f, -0.49f)
                curveToRelative(0.0f, -0.17f, -0.02f, -0.33f, -0.04f, -0.49f)
                lineToRelative(1.08f, -0.82f)
                curveToRelative(0.1f, -0.07f, 0.12f, -0.21f, 0.06f, -0.32f)
                lineToRelative(-1.03f, -1.73f)
                curveToRelative(-0.06f, -0.11f, -0.2f, -0.15f, -0.31f, -0.11f)
                lineToRelative(-1.28f, 0.5f)
                curveToRelative(-0.27f, -0.2f, -0.56f, -0.36f, -0.87f, -0.49f)
                lineToRelative(-0.2f, -1.33f)
                curveToRelative(0.0f, -0.12f, -0.11f, -0.21f, -0.24f, -0.21f)
                horizontalLineTo(5.98f)
                curveToRelative(-0.13f, 0.0f, -0.24f, 0.09f, -0.26f, 0.21f)
                lineToRelative(-0.2f, 1.32f)
                curveToRelative(-0.31f, 0.12f, -0.6f, 0.3f, -0.87f, 0.49f)
                lineToRelative(-1.28f, -0.5f)
                curveToRelative(-0.12f, -0.05f, -0.25f, 0.0f, -0.31f, 0.11f)
                lineToRelative(-1.03f, 1.73f)
                curveToRelative(-0.06f, 0.12f, -0.03f, 0.25f, 0.07f, 0.33f)
                lineToRelative(1.08f, 0.82f)
                curveToRelative(-0.02f, 0.16f, -0.03f, 0.33f, -0.03f, 0.49f)
                curveToRelative(0.0f, 0.17f, 0.02f, 0.33f, 0.04f, 0.49f)
                lineToRelative(-1.09f, 0.83f)
                curveToRelative(-0.1f, 0.07f, -0.12f, 0.21f, -0.06f, 0.32f)
                lineToRelative(1.03f, 1.73f)
                curveToRelative(0.06f, 0.11f, 0.2f, 0.15f, 0.31f, 0.11f)
                lineToRelative(1.28f, -0.5f)
                curveToRelative(0.27f, 0.2f, 0.56f, 0.36f, 0.87f, 0.49f)
                lineToRelative(0.2f, 1.32f)
                curveToRelative(0.01f, 0.12f, 0.12f, 0.21f, 0.25f, 0.21f)
                horizontalLineToRelative(2.06f)
                curveToRelative(0.13f, 0.0f, 0.24f, -0.09f, 0.25f, -0.21f)
                lineToRelative(0.2f, -1.32f)
                curveToRelative(0.31f, -0.12f, 0.6f, -0.3f, 0.87f, -0.49f)
                lineToRelative(1.28f, 0.5f)
                curveToRelative(0.12f, 0.05f, 0.25f, 0.0f, 0.31f, -0.11f)
                lineToRelative(1.03f, -1.73f)
                curveToRelative(0.06f, -0.11f, 0.04f, -0.24f, -0.06f, -0.32f)
                lineToRelative(-1.1f, -0.83f)
                close()
                moveTo(7.0f, 13.75f)
                curveToRelative(-0.99f, 0.0f, -1.8f, -0.78f, -1.8f, -1.75f)
                reflectiveCurveToRelative(0.81f, -1.75f, 1.8f, -1.75f)
                reflectiveCurveToRelative(1.8f, 0.78f, 1.8f, 1.75f)
                reflectiveCurveTo(8.0f, 13.75f, 7.0f, 13.75f)
                close()
                moveTo(18.0f, 1.01f)
                lineTo(8.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(14.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -1.99f, -2.0f, -1.99f)
                close()
            }
        }
        return _phonelinkSetup!!
    }

private var _phonelinkSetup: ImageVector? = null
