/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.KeyboardDoubleArrowRight: ImageVector
    get() {
        if (_keyboardDoubleArrowRight != null) {
            return _keyboardDoubleArrowRight!!
        }
        _keyboardDoubleArrowRight = materialIcon(name = "Filled.KeyboardDoubleArrowRight") {
            materialPath {
                moveTo(6.41f, 6.0f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(4.58f, 4.59f)
                lineToRelative(-4.58f, 4.59f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(6.0f, -6.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 6.0f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(4.58f, 4.59f)
                lineToRelative(-4.58f, 4.59f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(6.0f, -6.0f)
                close()
            }
        }
        return _keyboardDoubleArrowRight!!
    }

private var _keyboardDoubleArrowRight: ImageVector? = null
