/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.HistoryToggleOff: ImageVector
    get() {
        if (_historyToggleOff != null) {
            return _historyToggleOff!!
        }
        _historyToggleOff = materialIcon(name = "Filled.HistoryToggleOff") {
            materialPath {
                moveTo(15.1f, 19.37f)
                lineToRelative(1.0f, 1.74f)
                curveToRelative(-0.96f, 0.44f, -2.01f, 0.73f, -3.1f, 0.84f)
                verticalLineToRelative(-2.02f)
                curveTo(13.74f, 19.84f, 14.44f, 19.65f, 15.1f, 19.37f)
                close()
                moveTo(4.07f, 13.0f)
                horizontalLineTo(2.05f)
                curveToRelative(0.11f, 1.1f, 0.4f, 2.14f, 0.84f, 3.1f)
                lineToRelative(1.74f, -1.0f)
                curveTo(4.35f, 14.44f, 4.16f, 13.74f, 4.07f, 13.0f)
                close()
                moveTo(15.1f, 4.63f)
                lineToRelative(1.0f, -1.74f)
                curveTo(15.14f, 2.45f, 14.1f, 2.16f, 13.0f, 2.05f)
                verticalLineToRelative(2.02f)
                curveTo(13.74f, 4.16f, 14.44f, 4.35f, 15.1f, 4.63f)
                close()
                moveTo(19.93f, 11.0f)
                horizontalLineToRelative(2.02f)
                curveToRelative(-0.11f, -1.1f, -0.4f, -2.14f, -0.84f, -3.1f)
                lineToRelative(-1.74f, 1.0f)
                curveTo(19.65f, 9.56f, 19.84f, 10.26f, 19.93f, 11.0f)
                close()
                moveTo(8.9f, 19.37f)
                lineToRelative(-1.0f, 1.74f)
                curveToRelative(0.96f, 0.44f, 2.01f, 0.73f, 3.1f, 0.84f)
                verticalLineToRelative(-2.02f)
                curveTo(10.26f, 19.84f, 9.56f, 19.65f, 8.9f, 19.37f)
                close()
                moveTo(11.0f, 4.07f)
                verticalLineTo(2.05f)
                curveToRelative(-1.1f, 0.11f, -2.14f, 0.4f, -3.1f, 0.84f)
                lineToRelative(1.0f, 1.74f)
                curveTo(9.56f, 4.35f, 10.26f, 4.16f, 11.0f, 4.07f)
                close()
                moveTo(18.36f, 7.17f)
                lineToRelative(1.74f, -1.01f)
                curveToRelative(-0.63f, -0.87f, -1.4f, -1.64f, -2.27f, -2.27f)
                lineToRelative(-1.01f, 1.74f)
                curveTo(17.41f, 6.08f, 17.92f, 6.59f, 18.36f, 7.17f)
                close()
                moveTo(4.63f, 8.9f)
                lineToRelative(-1.74f, -1.0f)
                curveTo(2.45f, 8.86f, 2.16f, 9.9f, 2.05f, 11.0f)
                horizontalLineToRelative(2.02f)
                curveTo(4.16f, 10.26f, 4.35f, 9.56f, 4.63f, 8.9f)
                close()
                moveTo(19.93f, 13.0f)
                curveToRelative(-0.09f, 0.74f, -0.28f, 1.44f, -0.56f, 2.1f)
                lineToRelative(1.74f, 1.0f)
                curveToRelative(0.44f, -0.96f, 0.73f, -2.01f, 0.84f, -3.1f)
                horizontalLineTo(19.93f)
                close()
                moveTo(16.83f, 18.36f)
                lineToRelative(1.01f, 1.74f)
                curveToRelative(0.87f, -0.63f, 1.64f, -1.4f, 2.27f, -2.27f)
                lineToRelative(-1.74f, -1.01f)
                curveTo(17.92f, 17.41f, 17.41f, 17.92f, 16.83f, 18.36f)
                close()
                moveTo(7.17f, 5.64f)
                lineTo(6.17f, 3.89f)
                curveTo(5.29f, 4.53f, 4.53f, 5.29f, 3.9f, 6.17f)
                lineToRelative(1.74f, 1.01f)
                curveTo(6.08f, 6.59f, 6.59f, 6.08f, 7.17f, 5.64f)
                close()
                moveTo(5.64f, 16.83f)
                lineTo(3.9f, 17.83f)
                curveToRelative(0.63f, 0.87f, 1.4f, 1.64f, 2.27f, 2.27f)
                lineToRelative(1.01f, -1.74f)
                curveTo(6.59f, 17.92f, 6.08f, 17.41f, 5.64f, 16.83f)
                close()
                moveTo(13.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(5.41f)
                lineToRelative(4.29f, 4.29f)
                lineToRelative(1.41f, -1.41f)
                lineTo(13.0f, 11.59f)
                verticalLineTo(7.0f)
                close()
            }
        }
        return _historyToggleOff!!
    }

private var _historyToggleOff: ImageVector? = null
