/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.HideImage: ImageVector
    get() {
        if (_hideImage != null) {
            return _hideImage!!
        }
        _hideImage = materialIcon(name = "Filled.HideImage") {
            materialPath {
                moveTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.83f)
                lineTo(21.0f, 18.17f)
                verticalLineTo(5.0f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(3.0f, 5.83f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(13.17f)
                lineToRelative(1.61f, 1.61f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(6.0f, 17.0f)
                lineToRelative(3.0f, -4.0f)
                lineToRelative(2.25f, 3.0f)
                lineToRelative(0.82f, -1.1f)
                lineToRelative(2.1f, 2.1f)
                horizontalLineTo(6.0f)
                close()
            }
        }
        return _hideImage!!
    }

private var _hideImage: ImageVector? = null
