/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FreeCancellation: ImageVector
    get() {
        if (_freeCancellation != null) {
            return _freeCancellation!!
        }
        _freeCancellation = materialIcon(name = "Filled.FreeCancellation") {
            materialPath {
                moveTo(11.21f, 20.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(4.38f)
                lineToRelative(2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(5.0f)
                curveTo(3.89f, 4.0f, 3.01f, 4.9f, 3.01f, 6.0f)
                lineTo(3.0f, 20.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.21f)
                lineTo(11.21f, 20.0f)
                close()
                moveTo(16.54f, 22.5f)
                lineTo(13.0f, 18.96f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(4.24f, -4.24f)
                lineToRelative(1.41f, 1.41f)
                lineTo(16.54f, 22.5f)
                close()
                moveTo(10.41f, 14.0f)
                lineTo(12.0f, 15.59f)
                lineTo(10.59f, 17.0f)
                lineTo(9.0f, 15.41f)
                lineTo(7.41f, 17.0f)
                lineTo(6.0f, 15.59f)
                lineTo(7.59f, 14.0f)
                lineTo(6.0f, 12.41f)
                lineTo(7.41f, 11.0f)
                lineTo(9.0f, 12.59f)
                lineTo(10.59f, 11.0f)
                lineTo(12.0f, 12.41f)
                lineTo(10.41f, 14.0f)
                close()
            }
        }
        return _freeCancellation!!
    }

private var _freeCancellation: ImageVector? = null
