/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FlightLand: ImageVector
    get() {
        if (_flightLand != null) {
            return _flightLand!!
        }
        _flightLand = materialIcon(name = "Filled.FlightLand") {
            materialPath {
                moveTo(2.5f, 19.0f)
                horizontalLineToRelative(19.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-19.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(19.34f, 15.85f)
                curveToRelative(0.8f, 0.21f, 1.62f, -0.26f, 1.84f, -1.06f)
                curveToRelative(0.21f, -0.8f, -0.26f, -1.62f, -1.06f, -1.84f)
                lineToRelative(-5.31f, -1.42f)
                lineToRelative(-2.76f, -9.02f)
                lineTo(10.12f, 2.0f)
                verticalLineToRelative(8.28f)
                lineTo(5.15f, 8.95f)
                lineTo(4.22f, 6.63f)
                lineTo(2.77f, 6.24f)
                verticalLineToRelative(5.17f)
                lineTo(19.34f, 15.85f)
                close()
            }
        }
        return _flightLand!!
    }

private var _flightLand: ImageVector? = null
