/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FilterVintage: ImageVector
    get() {
        if (_filterVintage != null) {
            return _filterVintage!!
        }
        _filterVintage = materialIcon(name = "Filled.FilterVintage") {
            materialPath {
                moveTo(18.7f, 12.4f)
                curveToRelative(-0.28f, -0.16f, -0.57f, -0.29f, -0.86f, -0.4f)
                curveToRelative(0.29f, -0.11f, 0.58f, -0.24f, 0.86f, -0.4f)
                curveToRelative(1.92f, -1.11f, 2.99f, -3.12f, 3.0f, -5.19f)
                curveToRelative(-1.79f, -1.03f, -4.07f, -1.11f, -6.0f, 0.0f)
                curveToRelative(-0.28f, 0.16f, -0.54f, 0.35f, -0.78f, 0.54f)
                curveToRelative(0.05f, -0.31f, 0.08f, -0.63f, 0.08f, -0.95f)
                curveToRelative(0.0f, -2.22f, -1.21f, -4.15f, -3.0f, -5.19f)
                curveTo(10.21f, 1.85f, 9.0f, 3.78f, 9.0f, 6.0f)
                curveToRelative(0.0f, 0.32f, 0.03f, 0.64f, 0.08f, 0.95f)
                curveToRelative(-0.24f, -0.2f, -0.5f, -0.39f, -0.78f, -0.55f)
                curveToRelative(-1.92f, -1.11f, -4.2f, -1.03f, -6.0f, 0.0f)
                curveToRelative(0.0f, 2.07f, 1.07f, 4.08f, 3.0f, 5.19f)
                curveToRelative(0.28f, 0.16f, 0.57f, 0.29f, 0.86f, 0.4f)
                curveToRelative(-0.29f, 0.11f, -0.58f, 0.24f, -0.86f, 0.4f)
                curveToRelative(-1.92f, 1.11f, -2.99f, 3.12f, -3.0f, 5.19f)
                curveToRelative(1.79f, 1.03f, 4.07f, 1.11f, 6.0f, 0.0f)
                curveToRelative(0.28f, -0.16f, 0.54f, -0.35f, 0.78f, -0.54f)
                curveToRelative(-0.05f, 0.32f, -0.08f, 0.64f, -0.08f, 0.96f)
                curveToRelative(0.0f, 2.22f, 1.21f, 4.15f, 3.0f, 5.19f)
                curveToRelative(1.79f, -1.04f, 3.0f, -2.97f, 3.0f, -5.19f)
                curveToRelative(0.0f, -0.32f, -0.03f, -0.64f, -0.08f, -0.95f)
                curveToRelative(0.24f, 0.2f, 0.5f, 0.38f, 0.78f, 0.54f)
                curveToRelative(1.92f, 1.11f, 4.2f, 1.03f, 6.0f, 0.0f)
                curveToRelative(-0.01f, -2.07f, -1.08f, -4.08f, -3.0f, -5.19f)
                close()
                moveTo(12.0f, 16.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                reflectiveCurveToRelative(1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                reflectiveCurveToRelative(-1.79f, 4.0f, -4.0f, 4.0f)
                close()
            }
        }
        return _filterVintage!!
    }

private var _filterVintage: ImageVector? = null
