/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ChildCare: ImageVector
    get() {
        if (_childCare != null) {
            return _childCare!!
        }
        _childCare = materialIcon(name = "Filled.ChildCare") {
            materialPath {
                moveTo(14.5f, 10.5f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(9.5f, 10.5f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(22.94f, 12.66f)
                curveToRelative(0.04f, -0.21f, 0.06f, -0.43f, 0.06f, -0.66f)
                reflectiveCurveToRelative(-0.02f, -0.45f, -0.06f, -0.66f)
                curveToRelative(-0.25f, -1.51f, -1.36f, -2.74f, -2.81f, -3.17f)
                curveToRelative(-0.53f, -1.12f, -1.28f, -2.1f, -2.19f, -2.91f)
                curveTo(16.36f, 3.85f, 14.28f, 3.0f, 12.0f, 3.0f)
                reflectiveCurveToRelative(-4.36f, 0.85f, -5.94f, 2.26f)
                curveToRelative(-0.92f, 0.81f, -1.67f, 1.8f, -2.19f, 2.91f)
                curveToRelative(-1.45f, 0.43f, -2.56f, 1.65f, -2.81f, 3.17f)
                curveToRelative(-0.04f, 0.21f, -0.06f, 0.43f, -0.06f, 0.66f)
                reflectiveCurveToRelative(0.02f, 0.45f, 0.06f, 0.66f)
                curveToRelative(0.25f, 1.51f, 1.36f, 2.74f, 2.81f, 3.17f)
                curveToRelative(0.52f, 1.11f, 1.27f, 2.09f, 2.17f, 2.89f)
                curveTo(7.62f, 20.14f, 9.71f, 21.0f, 12.0f, 21.0f)
                reflectiveCurveToRelative(4.38f, -0.86f, 5.97f, -2.28f)
                curveToRelative(0.9f, -0.8f, 1.65f, -1.79f, 2.17f, -2.89f)
                curveToRelative(1.44f, -0.43f, 2.55f, -1.65f, 2.8f, -3.17f)
                close()
                moveTo(19.0f, 14.0f)
                curveToRelative(-0.1f, 0.0f, -0.19f, -0.02f, -0.29f, -0.03f)
                curveToRelative(-0.2f, 0.67f, -0.49f, 1.29f, -0.86f, 1.86f)
                curveTo(16.6f, 17.74f, 14.45f, 19.0f, 12.0f, 19.0f)
                reflectiveCurveToRelative(-4.6f, -1.26f, -5.85f, -3.17f)
                curveToRelative(-0.37f, -0.57f, -0.66f, -1.19f, -0.86f, -1.86f)
                curveToRelative(-0.1f, 0.01f, -0.19f, 0.03f, -0.29f, 0.03f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                curveToRelative(0.1f, 0.0f, 0.19f, 0.02f, 0.29f, 0.03f)
                curveToRelative(0.2f, -0.67f, 0.49f, -1.29f, 0.86f, -1.86f)
                curveTo(7.4f, 6.26f, 9.55f, 5.0f, 12.0f, 5.0f)
                reflectiveCurveToRelative(4.6f, 1.26f, 5.85f, 3.17f)
                curveToRelative(0.37f, 0.57f, 0.66f, 1.19f, 0.86f, 1.86f)
                curveToRelative(0.1f, -0.01f, 0.19f, -0.03f, 0.29f, -0.03f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                close()
                moveTo(7.5f, 14.0f)
                curveToRelative(0.76f, 1.77f, 2.49f, 3.0f, 4.5f, 3.0f)
                reflectiveCurveToRelative(3.74f, -1.23f, 4.5f, -3.0f)
                horizontalLineToRelative(-9.0f)
                close()
            }
        }
        return _childCare!!
    }

private var _childCare: ImageVector? = null
